<?php
include 'db.php';

$sucursal = $_POST['sucursal'] ?? '';
$fecha_inicio = $_POST['fecha_inicio'] ?? '';
$fecha_fin = $_POST['fecha_fin'] ?? '';

$facturado = $_POST['facturado'] ?? '';
$estado_factura = $_POST['estado_factura'] ?? '';

$where = "WHERE 1=1";

if ($sucursal !== '') {
    $where .= " AND v.sucursal_id = '$sucursal'";
}

if ($fecha_inicio !== '' && $fecha_fin !== '') {
    $where .= " AND DATE(v.fecha_y_hora) BETWEEN '$fecha_inicio' AND '$fecha_fin'";
} elseif ($fecha_inicio !== '') {
    $where .= " AND DATE(v.fecha_y_hora) = '$fecha_inicio'";
}

if ($facturado !== '') {
    $facturado_valor = ($facturado === 'SI') ? '1' : '0';
    $where .= " AND dv.facturado = '$facturado_valor'";
}

if ($estado_factura !== '') {
    $where .= " AND dv.estado_factura = '$estado_factura'";
}

// --- MODIFICACIÓN AQUÍ ---
// Se agregó p.exento_iva a la consulta
$query = "SELECT v.id AS venta_id, v.fecha_y_hora, v.total, s.nombre AS sucursal, 
                 dv.producto_id, dv.cantidad, dv.precio, dv.subtotal, p.NombreComercial, p.exento_iva
          FROM ventas v
          JOIN detalle_ventas dv ON v.id = dv.venta_id
          JOIN productos p ON dv.producto_id = p.id
          JOIN sucursales s ON v.sucursal_id = s.id
          $where
          ORDER BY v.fecha_y_hora DESC";

$result = $conn->query($query);

$ventas = [];
while ($row = $result->fetch_assoc()) {
    $venta_id = $row['venta_id'];
    if (!isset($ventas[$venta_id])) {
        $ventas[$venta_id] = [
            'fecha' => $row['fecha_y_hora'],
            'total' => $row['total'],
            'sucursal' => $row['sucursal'],
            'detalles' => []
        ];
    }
    // --- MODIFICACIÓN AQUÍ ---
    // Se guarda el valor de exento_iva
    $ventas[$venta_id]['detalles'][] = [
        'producto' => $row['NombreComercial'],
        'cantidad' => $row['cantidad'],
        'precio' => $row['precio'],
        'subtotal' => $row['subtotal'],
        'exento_iva' => $row['exento_iva'] // Guardamos el nuevo campo
    ];
}

if (!empty($ventas)) {
    foreach ($ventas as $id => $venta) {
        echo "<div class='card mb-3'>
                <div class='card-header'>
                    <strong>Venta #$id</strong> | Fecha: {$venta['fecha']} | Sucursal: {$venta['sucursal']} | Total: Q.{$venta['total']}
                </div>
                <div class='card-body'>
                    <table class='table table-sm'>
                        <thead>
                            <tr>
                                <th>Producto</th>
                                <th>Cantidad</th>
                                <th>Precio</th>
                                <th>Subtotal</th>
                                <th>Exento IVA</th>
                            </tr>
                        </thead>
                        <tbody>";
        foreach ($venta['detalles'] as $detalle) {
            // --- MODIFICACIÓN AQUÍ ---
            // Se muestra "Sí" o "No" basado en el valor de exento_iva
            $exento_texto = ($detalle['exento_iva'] == 1) ? 'Sí' : 'No';
            echo "<tr>
                    <td>{$detalle['producto']}</td>
                    <td>{$detalle['cantidad']}</td>
                    <td>Q. {$detalle['precio']}</td>
                    <td>Q. {$detalle['subtotal']}</td>
                    <td>{$exento_texto}</td>
                  </tr>";
        }
        echo "      </tbody>
                    </table>
                </div>
              </div>";
    }
} else {
    echo "<div class='alert alert-warning'>No se encontraron ventas en el rango especificado.</div>";
}
?>