<?php
// get_totales_dia.php
date_default_timezone_set('America/Guatemala'); // Ajusta la zona horaria según tu ubicación
include 'db_connection.php';
include 'sucursal_config.php';

// 1. Obtener total de ventas normales
$sqlNormal = "SELECT COALESCE(SUM(total), 0) AS total_normal
              FROM ventas
              WHERE DATE(fecha_y_hora) = CURDATE()
                AND sucursal_id = ?";
$stmtN = $conn->prepare($sqlNormal);
$stmtN->bind_param("i", $sucursal_id);
$stmtN->execute();
$resN = $stmtN->get_result();
$rowN = $resN->fetch_assoc();
$total_normal = (float)$rowN['total_normal'];

// 2. Obtener total de ventas especiales
$sqlEsp = "SELECT COALESCE(SUM(precio), 0) AS total_especial
           FROM ventas_especiales
           WHERE DATE(fecha_y_hora) = CURDATE()
             AND sucursal_id = ?";
$stmtE = $conn->prepare($sqlEsp);
$stmtE->bind_param("i", $sucursal_id);
$stmtE->execute();
$resE = $stmtE->get_result();
$rowE = $resE->fetch_assoc();
$total_especial = (float)$rowE['total_especial'];

// 3. Calcular Gran Total
$grand_total = $total_normal + $total_especial;

// 4. Responder
echo json_encode([
    'success' => true,
    'total_normal'   => $total_normal,
    'total_especial' => $total_especial,
    'grand_total'    => $grand_total
]);
?>
