<?php
include 'conexion.php';
include 'sucursal_config.php';

if(isset($_GET['search'])) {
    $search = mysqli_real_escape_string($conexion, $_GET['search']);
    $sucursal_id = isset($_GET['sucursal_id']) ? (int)$_GET['sucursal_id'] : $sucursal_id;
    
    $query = "SELECT DISTINCT p.*, i.existencia_unidad, i.existencia_blister, i.existencia_caja 
              FROM productos p 
              LEFT JOIN inventario_sucursal i ON p.id = i.producto_id AND i.sucursal_id = $sucursal_id
              WHERE p.estado = 1 
              AND (
                  p.CodigoInterno LIKE '%$search%' OR 
                  p.CodigoBarra LIKE '%$search%' OR 
                  p.NombreComercial LIKE '%$search%' OR 
                  p.NombreGenerico LIKE '%$search%' OR 
                  p.laboratorio LIKE '%$search%' OR 
                  p.FuncionMedica LIKE '%$search%' OR 
                  CONCAT(p.NombreComercial, ' ', p.laboratorio) LIKE '%$search%' OR 
                  CONCAT(p.NombreComercial, ' ', p.FuncionMedica) LIKE '%$search%' OR 
                  CONCAT(p.NombreGenerico, ' ', p.laboratorio) LIKE '%$search%'
              )
              ORDER BY p.NombreComercial 
              LIMIT 20";
    
    $result = mysqli_query($conexion, $query);
    $productos = array();
    
    while($row = mysqli_fetch_assoc($result)) {
        $text = $row['NombreComercial'];
        
        if (!empty($row['NombreGenerico'])) {
            $text .= ' - ' . $row['NombreGenerico'];
        }
        if (!empty($row['CodigoInterno'])) {
            $text .= ' [Código: ' . $row['CodigoInterno'] . ']';
        }
        if (!empty($row['laboratorio'])) {
            $text .= ' (' . $row['laboratorio'] . ')';
        }
        
        $productos[] = array(
            'id' => $row['id'],
            'text' => $text
        );
    }
    
    echo json_encode($productos);
    exit;
}