<?php
include 'conexion.php';
include 'sucursal_config.php';

$sucursal_id = isset($_GET['sucursal_id']) ? (int)$_GET['sucursal_id'] : $sucursal_id;

$query = "SELECT p.*, i.id as inventario_id, i.existencia_unidad, i.existencia_blister, i.existencia_caja,
                 i.fecha_vencimiento, c.nombre as categoria_nombre
          FROM productos p
          LEFT JOIN inventario_sucursal i ON p.id = i.producto_id AND i.sucursal_id = $sucursal_id
          LEFT JOIN categorias c ON p.id_categoria = c.id
          WHERE i.sucursal_id = $sucursal_id
          ORDER BY p.NombreComercial";

$result = mysqli_query($conexion, $query);
?>

<table class="table table-striped">
    <thead>
        <tr>
            <th>Código</th>
            <th>Producto</th>
            <th>Laboratorio</th>
            <th>Unidades</th>
            <th>Blister</th>
            <th>Cajas</th>
            <th>Fecha Vencimiento</th>
            <th>Acciones</th>
        </tr>
    </thead>
    <tbody>
        <?php while($row = mysqli_fetch_assoc($result)): ?>
        <tr data-id="<?php echo $row['inventario_id']; ?>">
            <td><?php echo $row['CodigoInterno'] ?? 'N/A'; ?></td>
            <td><?php echo $row['NombreComercial'] . ' - ' . $row['NombreGenerico']; ?></td>
            <td><?php echo $row['laboratorio']; ?></td>
            <td>
                <input type="number" class="form-control form-control-sm inventory-input" 
                       data-field="existencia_unidad" 
                       value="<?php echo $row['existencia_unidad'] ?? 0; ?>">
            </td>
            <td>
                <input type="number" class="form-control form-control-sm inventory-input" 
                       data-field="existencia_blister" 
                       value="<?php echo $row['existencia_blister'] ?? 0; ?>">
            </td>
            <td>
                <input type="number" class="form-control form-control-sm inventory-input" 
                       data-field="existencia_caja" 
                       value="<?php echo $row['existencia_caja'] ?? 0; ?>">
            </td>
            <td>
                <input type="date" class="form-control form-control-sm inventory-input" 
                       data-field="fecha_vencimiento" 
                       value="<?php echo $row['fecha_vencimiento'] ?? ''; ?>">
            </td>
            <td>
                <button class="btn btn-primary btn-sm save-row" style="display:none;">Guardar</button>
            </td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<script>
$(document).ready(function() {
    $('.inventory-input').on('change', function() {
        $(this).closest('tr').find('.save-row').show();
    });

    $('.save-row').on('click', function() {
        const $row = $(this).closest('tr');
        const inventarioId = $row.data('id');
        const data = {
            inventario_id: inventarioId,
            existencia_unidad: $row.find('[data-field="existencia_unidad"]').val(),
            existencia_blister: $row.find('[data-field="existencia_blister"]').val(),
            existencia_caja: $row.find('[data-field="existencia_caja"]').val(),
            fecha_vencimiento: $row.find('[data-field="fecha_vencimiento"]').val()
        };

        $.ajax({
            url: 'actualizar_inventario_inline.php',
            method: 'POST',
            data: data,
            success: function(response) {
                if(response === 'success') {
                    $row.find('.save-row').hide();
                    alert('Inventario actualizado correctamente');
                } else {
                    alert('Error al actualizar el inventario');
                }
            },
            error: function() {
                alert('Error al actualizar el inventario');
            }
        });
    });
});
</script>