<?php
include 'conexion.php';
include 'sucursal_config.php';

// Get branches except current one
$query_sucursales = "SELECT * FROM sucursales WHERE id != $sucursal_id ORDER BY nombre";
$resultado_sucursales = mysqli_query($conexion, $query_sucursales);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Traslados</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
</head>
<body>
    <div class="container mt-4">
        <h2 class="mb-4">Sistema de Traslados</h2>
        <a href="../index_simplificado.php" class="btn btn-secondary">Regresar a VENTAS</a>
        <div class="card">
            <div class="card-body">
                <form id="trasladoForm">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Sucursal Origen</label>
                            <input type="text" class="form-control" value="<?php 
                                $query = "SELECT nombre FROM sucursales WHERE id = $sucursal_id";
                                $result = mysqli_query($conexion, $query);
                                $sucursal = mysqli_fetch_assoc($result);
                                echo $sucursal['nombre'];
                            ?>" readonly>
                            <input type="hidden" name="sucursal_origen" value="<?php echo $sucursal_id; ?>">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Sucursal Destino</label>
                            <select class="form-select" name="sucursal_destino" required>
                                <option value="">Seleccione sucursal destino</option>
                                <?php while($sucursal = mysqli_fetch_assoc($resultado_sucursales)): ?>
                                    <option value="<?php echo $sucursal['id']; ?>">
                                        <?php echo $sucursal['nombre']; ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-12">
                            <label class="form-label">Agregar Producto</label>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <select class="form-select producto-select" id="producto-buscar">
                                        <option value="">Buscar producto...</option>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <input type="number" class="form-control" id="cantidad-unidad" placeholder="Unidades" min="0" value="0">
                                </div>
                                <div class="col-md-2">
                                    <input type="number" class="form-control" id="cantidad-blister" placeholder="Blister" min="0" value="0">
                                </div>
                                <div class="col-md-2">
                                    <input type="number" class="form-control" id="cantidad-caja" placeholder="Cajas" min="0" value="0">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <button type="button" class="btn btn-success" id="agregar-al-listado">Agregar al Listado</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-12">
                            <h4>Productos Seleccionados</h4>
                            <div class="table-responsive">
                                <table class="table table-bordered" id="tabla-productos">
                                    <thead>
                                        <tr>
                                            <th>Producto</th>
                                            <th>Unidades</th>
                                            <th>Blister</th>
                                            <th>Cajas</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Observaciones</label>
                        <textarea class="form-control" name="observaciones" rows="3"></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary">Realizar Traslado</button>
                </form>
            </div>
        </div>

        <div class="mt-4">
            <h3>Traslados Pendientes</h3>
            <div id="trasladosPendientes"></div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            let productosSeleccionados = [];

            // Initialize Select2 for product search
            $('#producto-buscar').select2({
                placeholder: 'Buscar producto...',
                minimumInputLength: 2,
                ajax: {
                    url: 'buscar_productos_sucursal.php',
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            search: params.term,
                            sucursal_id: $('input[name="sucursal_origen"]').val()
                        };
                    },
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: false
                }
            });

            // Add product to list
            $('#agregar-al-listado').click(function() {
                const producto = $('#producto-buscar').select2('data')[0];
                if (!producto) {
                    alert('Por favor seleccione un producto');
                    return;
                }

                const unidades = parseInt($('#cantidad-unidad').val()) || 0;
                const blister = parseInt($('#cantidad-blister').val()) || 0;
                const cajas = parseInt($('#cantidad-caja').val()) || 0;

                if (unidades === 0 && blister === 0 && cajas === 0) {
                    alert('Debe especificar al menos una cantidad');
                    return;
                }

                // Add to array
                productosSeleccionados.push({
                    id: producto.id,
                    nombre: producto.text,
                    unidades: unidades,
                    blister: blister,
                    cajas: cajas
                });

                // Add to table
                const newRow = `
                    <tr data-id="${producto.id}">
                        <td>${producto.text}</td>
                        <td>${unidades}</td>
                        <td>${blister}</td>
                        <td>${cajas}</td>
                        <td>
                            <button type="button" class="btn btn-danger btn-sm eliminar-producto">
                                Eliminar
                            </button>
                        </td>
                    </tr>
                `;
                $('#tabla-productos tbody').append(newRow);

                // Clear form
                $('#producto-buscar').val(null).trigger('change');
                $('#cantidad-unidad, #cantidad-blister, #cantidad-caja').val(0);
            });

            // Remove product from list
            $(document).on('click', '.eliminar-producto', function() {
                const row = $(this).closest('tr');
                const productoId = row.data('id');
                productosSeleccionados = productosSeleccionados.filter(p => p.id != productoId);
                row.remove();
            });

            // Handle form submission
            $('#trasladoForm').on('submit', function(e) {
                e.preventDefault();
                if (productosSeleccionados.length === 0) {
                    alert('Debe agregar al menos un producto');
                    return;
                }

                const formData = {
                    sucursal_origen: $('input[name="sucursal_origen"]').val(),
                    sucursal_destino: $('select[name="sucursal_destino"]').val(),
                    observaciones: $('textarea[name="observaciones"]').val(),
                    productos: productosSeleccionados.map(p => p.id),
                    cantidad_unidad: productosSeleccionados.map(p => p.unidades),
                    cantidad_blister: productosSeleccionados.map(p => p.blister),
                    cantidad_caja: productosSeleccionados.map(p => p.cajas)
                };

                $.ajax({
                    url: 'guardar_traslado.php',
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        alert('Traslado registrado correctamente');
                        cargarTrasladosPendientes();
                        // Reset form
                        $('#trasladoForm')[0].reset();
                        productosSeleccionados = [];
                        $('#tabla-productos tbody').empty();
                        $('#producto-buscar').val(null).trigger('change');
                    },
                    error: function() {
                        alert('Error al registrar el traslado');
                    }
                });
            });

            function cargarTrasladosPendientes() {
                $.ajax({
                    url: 'obtener_traslados_pendientes.php',
                    method: 'GET',
                    success: function(response) {
                        $('#trasladosPendientes').html(response);
                    }
                });
            }

            cargarTrasladosPendientes();
        });
    </script>
</body>
</html>